DROP TABLE IF EXISTS `site_plugin_team_cats`;
CREATE TABLE `site_plugin_team_cats` (
  `cat_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `cat_order` int(11) NOT NULL,
  `cat_status` int(11) NOT NULL,
  `cat_size` varchar(5) NOT NULL,
  `cat_size_lg` varchar(5) NOT NULL,
  `cat_size_md` varchar(5) NOT NULL,
  `cat_size_sm` varchar(5) NOT NULL,
  `cat_size_xs` varchar(5) NOT NULL,
  `cat_icon` varchar(255) NOT NULL,
  `cat_tn_type` int(2) NOT NULL,
  `cat_tn_icon` varchar(255) NOT NULL,
  `cat_tn_image` int(1) NOT NULL,
  `cat_css_list` varchar(255) NOT NULL,
  `cat_css_details` varchar(255) NOT NULL,
  PRIMARY KEY (`cat_id`),
  KEY `module_id` (`module_id`,`cat_order`,`cat_status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_team_cats_lang`;
CREATE TABLE `site_plugin_team_cats_lang` (
  `cat_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `cat_title` varchar(255) NOT NULL,
  `cat_url` varchar(255) NOT NULL,
  `cat_description` text NOT NULL,
  `cat_brief` text NOT NULL,
  `seo_title` text NOT NULL,
  `seo_desc` text NOT NULL,
  `seo_meta` text NOT NULL,
  `seo_conv_head` text NOT NULL,
  `seo_conv_body` text NOT NULL,
  `cat_tn_image_alt` varchar(255) NOT NULL,
  KEY `cat_id` (`cat_id`,`module_id`,`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_team_fields`;
CREATE TABLE `site_plugin_team_fields` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `item_order` int(11) NOT NULL,
  `item_name` varchar(100) NOT NULL,
  `item_icon` varchar(200) NOT NULL,
  `item_link_target` varchar(20) NOT NULL,
  `item_link_rel` varchar(20) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `module_id` (`module_id`,`item_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_team_fields_values`;
CREATE TABLE `site_plugin_team_fields_values` (
  `val_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `team_id` int(11) NOT NULL,
  `val_value` varchar(255) NOT NULL,
  PRIMARY KEY (`val_id`),
  KEY `module_id` (`module_id`,`field_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_team_items`;
CREATE TABLE `site_plugin_team_items` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `item_order` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `item_image` int(1) NOT NULL,
  `item_bg` int(1) NOT NULL,
  `item_status` int(1) NOT NULL,
  `item_tn` int(11) NOT NULL,
  `item_title` varchar(255) NOT NULL,
  `item_facebook` varchar(255) NOT NULL,
  `item_twitter` varchar(255) NOT NULL,
  `item_gplus` varchar(255) NOT NULL,
  `item_email` varchar(255) NOT NULL,
  `item_linkedin` varchar(255) NOT NULL,
  `item_skype` varchar(255) NOT NULL,
  `item_phone` varchar(50) NOT NULL,
  `item_cell` varchar(50) NOT NULL,
  `item_phone_work` varchar(50) NOT NULL,
  `item_phone_cell` varchar(50) NOT NULL,
  `item_cat` text NOT NULL,
  `item_link_type` int(1) NOT NULL,
  `item_link_module` int(11) NOT NULL,
  `item_link_target` varchar(10) NOT NULL,
  `item_link_global` int(11) NOT NULL,
  `item_link_rel` varchar(30) NOT NULL,
  `item_css_list` varchar(255) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `item_id` (`item_id`,`module_id`),
  KEY `item_order` (`item_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_team_items_lang`;
CREATE TABLE `site_plugin_team_items_lang` (
  `item_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `item_image_alt` varchar(255) NOT NULL,
  `item_brief` text NOT NULL,
  `item_position` varchar(255) NOT NULL,
  `item_link_link` text NOT NULL,
  `item_link_text` text NOT NULL,
  `item_brief_title` varchar(50) NOT NULL,
  KEY `item_id` (`item_id`,`lang_id`),
  KEY `module_id` (`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

